;
; acsi - header file
;
; soll eine direkte acsi operation unter dos durchgefuehrt werden, so
; muss dies folgendermassen erfolgen:
;
; - lade es:bx mit pointer auf den acsi request block
; - lade ah mit 8 --> acsi service
; - int 78h durchfuehren
; - die resultate stehen im acsi request block
;
; aufbau des acsi reqeust blocks - alle werte im intel format
;
;               laenge  offset     funktion                 dir
; es:bx ------->  b      0         operationcode            entry
;                 b      1         dataflag                 entry
;                 b      2         status                   exit
;                 b      3         logische unit nummer     entry
;                 b      4         phys adapternummer       entry/exit
;                 b      5         phys partitionsnummer    exit
;                 4      6         absoluter offset         exit
;                 4      10        absolute laenge          exit
;                 4      14        startblock               entry
;                 2      18        blockcount               entry
;                 2      20        buffer offset            entry
;                 2      22        buffer segment           entry
;		  4	 24	   command timeout	    entry
;		  4	 28 	   status timeout	    entry
;  
; operationcodes:
; ---------------
; bit 7-5      command class
; bit 4-0      opcode
;
; class        opcodes
; 0 0 0        0  get phys unit data
;		  beim aufruf wird lediglich die log. dos unitnummer uerbgeben
;		  beim ruekcsprung erhaelt man die adapternummer, partitions-
;		  nummer, absoluter start der partitin und laenge der partition.
;	       alle anderen opcodes haben momentan keine bedeutung
;
; 
; 0 0 1        acsi opcode (use logic unit number)
;              startblock=offset vom unitstart
; 0 1 0        acsi opcode (use physical adapter number)
;              startblock=offset vom phys start
;
; der blockcount muss kleiner als 254 sein!
; die transferadresse muss gerade sein!
;
; logische unitnummer:
; --------------------
;
; die logischen untinummern laufen von $80 bis ...
;
; die phys. adapternummer wird bereits in bit 7-5 uebergeben.
;
; status:
; -------
; FF           illegal operation code
; FE           unit nicht vorhanden
; 7F	       acsi device timeout
; 7E	       acsi device timeout
; 
; dataflag:
; ---------
; bit 7    1=datenphase ist vorhanden
; bit 6	   1=startblock so eintragen, wie uebergeben
;	   0=startblock absolut eintragen
; bit 5	   1=use timeout parameter in request block
;	   0=use default timeout parameter
; bit 4-1  -- keine bedeutung --
; bit 0    0=lesen 1=schreiben
;
;
acsi_rqb	struc
opcode		db	0	 ; 0  function opcode
dataflag	db	0	 ; 1  dataflag
status		db	0	 ; 2  status
unit		db	0	 ; 3  logische unitnummer
adapt		db	0	 ; 4  phys adapternummer
part		db	0	 ; 5  partitionsnummer auf diesem adapter
unit_start	db	4 dup(0) ; 6  absoluter unit start auf diesem adapter
unit_len	db	4 dup(0) ; 10 unitlaenge in 512 byte bloecken
start		db	4 dup(0) ; 14 transfer startblock
count		dw	0	 ; 18 block count
transfer_ofs	dw	0	 ; 20 offset transferbuffer
transfer_seg	dw	0	 ; 22 segment transferbuffer
short_to	db	4 dup(0) ; 24 command timeout in 5 msec einheiten
long_to		db	4 dup(0) ; 28 status timeout  ---"---
acsi_rqb	ends
